/* <nagd01.h>
   *
   * Copyright 1996 Numerical Algorithms Group
   *
   * Include file for NAG C Library d01 Chapter
   *
   * Mark 4, revised, 1996.
   * Mark 5 revised. IER-2144 (Feb 1998).
   * Mark 6 revised. IER-3068 (Aug 2000).
   */
#ifndef NAGD01
#define NAGD01

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL d01ajc(NAG_D01AJC_FUN f , double a, double b, 
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             NagError *fail);
   //Cheney  2006-6-5 add typedef for pointer to function
  /*extern void d01ajf_f(double (*f)(double ),
                       double a, double b, double epsabs, double epsrel,
                       double *result, double *abserr, double work[], Integer lwork,
                       Integer iwork[], Integer liwork, Integer *ifail);*/
    extern void d01ajf_f(NAG_D01AJF_F_FUN f,
                       double a, double b, double epsabs, double epsrel,
                       double *result, double *abserr, double work[], Integer lwork,
                       Integer iwork[], Integer liwork, Integer *ifail);
    //Cheney 2006-6-5 add typedef for pointer to function
   /*extern void d01ajv_f(double (*f)(double ),
                       double a, double b, double epsabs, double epsrel,
                       double alist_[], double blist[], double elist[], double rlist[],
                       Integer limit, Integer iord[], Integer liord, double *result,
                       double *abserr, Integer *neval, Integer *ier);*/
    extern void d01ajv_f(NAG_D01AJV_F_FUN f,
                       double a, double b, double epsabs, double epsrel,
                       double alist_[], double blist[], double elist[], double rlist[],
                       Integer limit, Integer iord[], Integer liord, double *result,
                       double *abserr, Integer *neval, Integer *ier);
  extern void d01ajv(NAG_D01_FUN f, double a, double b,
                     double epsabs, double epsrel, double alist[],
                     double blist[], double elist[], double rlist[],
                     Integer limit, Integer iord[], double *result,
                     double *abserr, Integer *neval, Integer *ier,
                     Integer *funeval, char buf[]);
  extern void d01ajx_f(Integer limit, Integer last, Integer *maxerr, double *ermax,
                       const double elist[], Integer iord[], Integer *nrmax);
  extern void d01ajx(Integer limit, Integer last, Integer *maxerr,
                     double *ermax, double elist[], Integer iord[],
                     Integer *nrmax);
  extern void d01ajy_f(Integer *n, double epstab[], double *result, double *abserr,
                       double res3la[], Integer *nres);
  extern void d01ajy(Integer *n, double epstab[], double *result,
                     double *abserr, double res3la[], Integer *nres);
   //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void d01ajz_f(double (*f)(double ),
                       double a, double b, double *result, double *abserr,
                       double *resabs, double *resasc);*/
    extern void d01ajz_f(NAG_D01AJZ_F_FUN f,
                       double a, double b, double *result, double *abserr,
                       double *resabs, double *resasc);
  extern void d01ajz(NAG_D01_FUN f, double a, double b,
                     double *result, double *abserr, double *resabs,
                     double *resasc, Integer *funeval);
  extern NAG_DLL_EXPIMP void NAG_CALL d01akc(NAG_D01AKC_FUN f, double a, double b, 
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             NagError *fail);
  extern void d01akv(NAG_D01_FUN f, double a, double b,
                     Integer key, double epsabs, double epsrel,
                     double alist[], double blist[], double elist[],
                     double rlist[], Integer limit, Integer iord[],
                     double *result, double *abserr, Integer *neval,
                     Integer *last, Integer *ier, Integer *funeval, char buf[]);
  extern void d01akz(NAG_D01_FUN f, double a, double b,
                     double *result, double *abserr, double *resabs,
                     double *resasc, Integer *funeval);
  extern NAG_DLL_EXPIMP void NAG_CALL d01alc(NAG_D01ALC_FUN f, double a, double b, 
                                             Integer nbrkpts, double brkpts[], double epsabs,
                                             double epsrel, Integer max_num_subint, double *result,
                                             double *abserr, Nag_QuadProgress *qp, NagError *fail);
  extern void d01alv(NAG_D01_FUN f, double a, double b,
                     Integer npts2, double points[], double *pts,
                     double epsabs, double epsrel, double alist[],
                     double blist[], double elist[], double rlist[],
                     Integer limit, Integer iord[], Integer *level,
                     Integer *ndin, double *result, double *abserr,
                     Integer *neval, Integer *ier, Integer *funeval, char buf[]);
  extern NAG_DLL_EXPIMP void NAG_CALL d01amc(NAG_D01AMC_FUN f, Nag_BoundInterval boundinf, double bound, 
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             NagError *fail);
  //Cheney  2006-6-5 add typedef for pointer to function
  /*extern void d01amf_f(double (*f)(double ),
                       double bound, Integer inf, double epsabs, double epsrel,
                       double *result, double *abserr, double work[], Integer lwork,
                       Integer iwork[], Integer liwork, Integer *ifail);*/
   extern void d01amf_f(NAG_D01AMF_F_FUN f,
                       double bound, Integer inf, double epsabs, double epsrel,
                       double *result, double *abserr, double work[], Integer lwork,
                       Integer iwork[], Integer liwork, Integer *ifail);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void d01amv_f(double (*f)(double ),
                       double bound, Integer inf, double epsabs, double epsrel,
                       double alist_[], double blist[], double elist[], double rlist[],
                       Integer limit, Integer iord[], Integer liord, double *result,
                       double *abserr, Integer *neval, Integer *ier);*/
  extern void d01amv_f(NAG_D01AMV_F_FUN f,
                       double bound, Integer inf, double epsabs, double epsrel,
                       double alist_[], double blist[], double elist[], double rlist[],
                       Integer limit, Integer iord[], Integer liord, double *result,
                       double *abserr, Integer *neval, Integer *ier);
  extern void d01amv(NAG_D01_FUN f, double bound, Integer boundinf,
                     double epsabs, double epsrel, double alist[],
                     double blist[], double elist[], double rlist[],
                     Integer limit, Integer iord[], double *result,
                     double *abserr, Integer *neval, Integer *ier, Integer *funeval,
                     char buf[]);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void d01amz_f(double (*f)(double ),
                       double boun, Integer inf, double a, double b,
                       double *result, double *abserr, double *resabs, double *resasc);*/
  extern void d01amz_f(NAG_D01AMZ_F_FUN f,
                       double boun, Integer inf, double a, double b,
                       double *result, double *abserr, double *resabs, double *resasc);
  extern void d01amz(NAG_D01_FUN f, double boun, Integer inf,
                     double a, double b, double *result,
                     double *abserr, double *resabs, double *resasc, Integer *funeval);
  extern NAG_DLL_EXPIMP void NAG_CALL d01anc(NAG_D01ANC_FUN g, double a, double b, 
                                             double omega, Nag_TrigTransform wt_func, double epsabs,
                                             double epsrel, Integer max_num_subint, double *result,
                                             double *abserr, Nag_QuadProgress *qp,  NagError *fail);
  extern void d01anv(NAG_D01_FUN g, double a, double b,
                     double epsabs, double epsrel, double alist[],
                     double blist[], double elist[], double rlist[],
                     double chebmo[], Integer  maxp1, Integer  limit,
                     Integer iord[], Integer nnlog[], double *result,
                     double *abserr,double omega,
                     Integer integr, Integer icall, 
                     Integer *momcom, Integer *neval,
                     Integer *ier, Integer *funeval, char buf[]);
  extern void d01anw(NAG_D01_FUN g, double a, double b,
                     double omega, Integer integr, Integer nrmom,
                     Integer maxp1, Integer ksave, double *result,
                     double *abserr, Integer *neval, double *resabs,
                     double *resasc, Integer *momcom, double chebmo[],
                     Integer *funeval);
  extern void d01anx(double *x, double fval[], double cheb12[],
                     double cheb24[]);
  extern double d01any(double x, double omega, double p2, double p3,
                       double p4, Integer integr);
  extern NAG_DLL_EXPIMP void NAG_CALL d01apc(NAG_D01APC_FUN g, double a, double b, 
                                             double alfa, double beta, Nag_QuadWeight  wt_func,
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             NagError *fail);
  extern void d01apv(NAG_D01_FUN g, double a, double b,
                     double alfa, double beta, double epsabs,
                     double epsrel, double alist[], double blist[],
                     double elist[], double rlist[], Integer  limit,
                     Integer iord[], Integer integr,
                     double *result, double *abserr, Integer *neval,
                     Integer *ier, Integer *funeval, char buf[]);
  extern void d01apw(double alfa, double beta, double ri[],
                     double rj[], double rg[], double rh[], Integer integr);
  extern void d01apx(NAG_D01_FUN g, double a, double b,
                     double bl, double br, double alfa,
                     double beta, double ri[], double rj[], double rg[],
                     double rh[], double *result, double *abserr,
                     double *resasc, Integer  integr, Integer *nev,
                     Integer *funeval);
  extern double d01apy(double x, double a, double b, double alfa,
                       double beta, Integer integr);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void d01apz(NAG_D01_FUN g,
                     double (*w) (double x, double omega, double p2, double p3,
                                  double p4, Integer integr),
                     double p1,
                     double p2, double p3, double p4, Integer kp,
                     double a, double b, double *result,
                     double *abserr, double *resabs, double *resasc,
                     Integer *funeval);*/
    extern void d01apz(NAG_D01_FUN g,
                     NAG_D01APZ_FUN w,
                     double p1,
                     double p2, double p3, double p4, Integer kp,
                     double a, double b, double *result,
                     double *abserr, double *resabs, double *resasc,
                     Integer *funeval);
  extern NAG_DLL_EXPIMP void NAG_CALL d01aqc(NAG_D01AQC_FUN g, double a, double b, 
                                             double c, double epsabs, double epsrel,
                                             Integer max_num_subint, double *result,
                                             double *abserr, Nag_QuadProgress *qp, NagError *fail);
  extern void d01aqv(NAG_D01_FUN g, double a, double b, double c,
                     double epsabs, double epsrel, double alist[],
                     double blist[], double elist[], double rlist[],
                     Integer  limit, Integer iord[], double *result,
                     double *abserr, Integer *neval, Integer *last, Integer *ier,
                     Integer *funeval, char buf[]);
  extern void d01aqy(NAG_D01_FUN g, double a, double b, double c,
                     double *result, double *abserr, Integer *krul,
                     Integer *neval, Integer *funeval);
  extern double d01aqz(double x, double c, double p2, double p3,
                       double p4, Integer  kp);
  extern NAG_DLL_EXPIMP void NAG_CALL d01asc(NAG_D01ASC_FUN g, double a, 
                                             double omega, Nag_TrigTransform wt_func,
                                             Integer maxintervals,
                                             Integer maxsubint_per_int,
                                             double epsabs,
                                             double *result, double *abserr,
                                             Nag_QuadSubProgress *qpsub,
                                             NagError *fail);
  extern void d01asv(NAG_D01_FUN g, double a, double epsabs,
                     double alist[], double blist[], double elist[],
                     double rlist[], double chebmo[], Integer maxp1,
                     double erlst[], double rslst[], Integer ierlst[],
                     Integer limlst, Integer limit, Integer iord[], 
                     Integer nnlog[], double *result, double *abserr,
                     double omega, Integer integr, Integer *lst, Integer *neval,
                     Integer *ier, Integer *funeval, char buf[], NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL d01bac(Nag_GaussFormulae quadrule, NAG_D01BAC_FUN fun,
                                               double a, double b, Integer npts, NagError *fail);
  extern void d01baw(double a, double b, Integer itype, Integer npts,
                     double weight[], double abscis[], Integer *fail);
  extern void d01bax(double a, double b, Integer itype, Integer npts,
                     double weight[], double abscis[], Integer *fail);
  extern void d01bay(double a, double b, Integer itype, Integer npts,
                     double weight[], double abscis[], Integer *fail);
  extern void d01baz(double a, double b, Integer itype, Integer npts,
                     double weight[], double abscis[], Integer *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL d01bbc(Nag_GaussFormulae quadrule, double a, double b,
                                             Integer itype, Integer npts, double weight[],
                                             double abscis[], NagError *fail);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void d01daf_f(double ya, double yb, 
                       double (*phi1)(double ),
                       double (*phi2)(double ),
                       double (*f)(double , double ),
                       double absacc, double *ans, Integer *npts, Integer *ifail);
  extern void d01daf_c(double ya, double yb, 
                       double (*phi1)(double, Nag_User * ),
                       double (*phi2)(double, Nag_User * ),
                       double (*f)(double , double, Nag_User * ),
                       double absacc, double *ans, Integer *npts,
		       Nag_User *comm, Integer *ifail);*/
   extern void d01daf_f(double ya, double yb, 
                       NAG_D01DAF_F1_FUN phi1,
                       NAG_D01DAF_F1_FUN phi2,
                       NAG_D01DAF_F2_FUN f,
                       double absacc, double *ans, Integer *npts, Integer *ifail);
  extern void d01daf_c(double ya, double yb, 
                       NAG_D01DAF_C1_FUN phi1,
                       NAG_D01DAF_C1_FUN phi2,
                       NAG_D01DAF_C2_FUN f,
                       double absacc, double *ans, Integer *npts,
		       Nag_User *comm, Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL d01fcc(Integer ndim, NAG_D01FCC_FUN functn, double a[], 
                                             double b[], Integer *minpts, Integer maxpts,  double eps,
                                             double *finval, double *acc, NagError *fail);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void d01fcf_f(Integer ndim, const double a[], const double b[], Integer *minpts,
                       Integer maxpts, 
                       double (*functn)(Integer , const double []),
                       double eps, double *acc, Integer lenwrk, double wrkstr[],
                       double *finval, Integer *ifail);*/
  extern void d01fcf_f(Integer ndim, const double a[], const double b[], Integer *minpts,
                       Integer maxpts, 
                       NAG_D01FCF_F_FUN f,
                       double eps, double *acc, Integer lenwrk, double wrkstr[],
                       double *finval, Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL d01gac(Integer n, double x[], double y[], double *ans,
                                             double *er, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL d01gbc(Integer numvar, NAG_D01GBC_FUN functn, 
                                             Nag_MCMethod method, Nag_Start cont, double a[], double b[],
                                             Integer *minpts, Integer maxpts, double releps, double *finval,
                                             double *relerr, double **wrkstr, NagError *fail);
  extern void d01gbz(Integer numvar, double a[], double b[],
                     Integer *minpts, Integer maxpts,
                     NAG_D01GBC_FUN functn,
                     double releps, double *relerr, double cntlim[],
                     double countr[], double lower[], double pointr[],
                     double bmnusa[], double width[], double x[],
                     Integer lenwrk, double wrkstr[], double *finval,
                     Integer *ierror);
  extern NAG_DLL_EXPIMP void NAG_CALL d01sjc(NAG_D01SJC_FUN f , double a, double b, 
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             Nag_User *comm, NagError *fail);
  extern void d01sjv(NAG_D01_TS_FUN f, double a, double b,
                     double epsabs, double epsrel, double alist[],
                     double blist[], double elist[], double rlist[],
                     Integer limit, Integer iord[], double *result,
                     double *abserr, Integer *neval, Integer *ier,
                     Integer *funeval, char buf[], Nag_User *comm);
  extern void d01sjz(NAG_D01_TS_FUN f, double a, double b,
                     double *result, double *abserr, double *resabs,
                     double *resasc, Integer *funeval, Nag_User *comm);
  extern NAG_DLL_EXPIMP void NAG_CALL d01skc(NAG_D01SKC_FUN f, double a, double b, 
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             Nag_User *comm, NagError *fail);
  extern void d01skv(NAG_D01_TS_FUN f, double a, double b,
                     Integer key, double epsabs, double epsrel,
                     double alist[], double blist[], double elist[],
                     double rlist[], Integer limit, Integer iord[],
                     double *result, double *abserr, Integer *neval,
                     Integer *last, Integer *ier, Integer *funeval,
                     char buf[], Nag_User *comm);
  extern void d01skz(NAG_D01_TS_FUN f, double a, double b,
                     double *result, double *abserr, double *resabs,
                     double *resasc, Integer *funeval, Nag_User *comm);
  extern NAG_DLL_EXPIMP void NAG_CALL d01slc(NAG_D01SLC_FUN f, double a, double b, 
                                             Integer nbrkpts, double brkpts[], double epsabs,
                                             double epsrel, Integer max_num_subint, double *result,
                                             double *abserr, Nag_QuadProgress *qp, 
                                             Nag_User *comm, NagError *fail);
  extern void d01slv(NAG_D01_TS_FUN f, double a, double b,
                     Integer npts2, double points[], double *pts,
                     double epsabs, double epsrel, double alist[],
                     double blist[], double elist[], double rlist[],
                     Integer limit, Integer iord[], Integer *level,
                     Integer *ndin, double *result, double *abserr,
                     Integer *neval, Integer *ier,
                     Integer *funeval, char buf[], Nag_User *comm);
  extern NAG_DLL_EXPIMP void NAG_CALL d01smc(NAG_D01SMC_FUN f, Nag_BoundInterval boundinf, double bound, 
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             Nag_User *comm, NagError *fail);
  extern void d01smv(NAG_D01_TS_FUN f, double bound, Integer boundinf,
                     double epsabs, double epsrel, double alist[],
                     double blist[], double elist[], double rlist[],
                     Integer limit, Integer iord[], double *result,
                     double *abserr, Integer *neval, Integer *ier, 
                     Integer *funeval,
                     char buf[], Nag_User *comm);
  extern void d01smz(NAG_D01_TS_FUN f, double boun, Integer inf,
                     double a, double b, double *result,
                     double *abserr, double *resabs, double *resasc, 
                     Integer *funeval, Nag_User *comm);
  extern NAG_DLL_EXPIMP void NAG_CALL d01snc(NAG_D01SNC_FUN g, double a, double b, 
                                             double omega, Nag_TrigTransform wt_func, double epsabs,
                                             double epsrel, Integer max_num_subint, double *result,
                                             double *abserr, Nag_QuadProgress *qp,
                                             Nag_User *comm, NagError *fail);
  extern void d01snv(NAG_D01_TS_FUN g, double a, double b,
                     double epsabs, double epsrel, double alist[],
                     double blist[], double elist[], double rlist[],
                     double chebmo[], Integer  maxp1, Integer  limit,
                     Integer iord[], Integer nnlog[], double *result,
                     double *abserr,double omega,
                     Integer integr, Integer icall, 
                     Integer *momcom, Integer *neval,
                     Integer *ier, Integer *funeval, 
                     char buf[], Nag_User *comm);
  extern void d01snw(NAG_D01_TS_FUN g, double a, double b,
                     double omega, Integer integr, Integer nrmom,
                     Integer maxp1, Integer ksave, double *result,
                     double *abserr, Integer *neval, double *resabs,
                     double *resasc, Integer *momcom, double chebmo[],
                     Integer *funeval, Nag_User *comm);
  extern NAG_DLL_EXPIMP void NAG_CALL d01spc(NAG_D01SPC_FUN g, double a, double b, 
                                             double alfa, double beta, Nag_QuadWeight  wt_func,
                                             double epsabs, double epsrel, Integer max_num_subint,
                                             double *result, double *abserr, Nag_QuadProgress *qp,
                                             Nag_User *comm, NagError *fail);
  extern void d01spv(NAG_D01_TS_FUN g, double a, double b,
                     double alfa, double beta, double epsabs,
                     double epsrel, double alist[], double blist[],
                     double elist[], double rlist[], Integer  limit,
                     Integer iord[], Integer integr, double *result, 
                     double *abserr, Integer *neval, Integer *ier,
                     Integer *funeval, char buf[], Nag_User *comm);
  extern void d01spx(NAG_D01_TS_FUN g, double a, double b,
                     double bl, double br, double alfa,
                     double beta, double ri[], double rj[], double rg[],
                     double rh[], double *result, double *abserr,
                     double *resasc, Integer  integr, Integer *nev,
                     Integer *funeval, Nag_User *comm);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void d01spz(NAG_D01_TS_FUN g,
                     double (*w) (double x, double omega, double p2, double p3,
                                  double p4, Integer integr),
                     double p1,
                     double p2, double p3, double p4, Integer kp,
                     double a, double b, double *result,
                     double *abserr, double *resabs, double *resasc,
                     Integer *funeval, Nag_User *comm);*/
  extern void d01spz(NAG_D01_TS_FUN g,
                     NAG_D01SPZ_FUN w,
                     double p1,
                     double p2, double p3, double p4, Integer kp,
                     double a, double b, double *result,
                     double *abserr, double *resabs, double *resasc,
                     Integer *funeval, Nag_User *comm);
  extern NAG_DLL_EXPIMP void NAG_CALL d01sqc(NAG_D01SQC_FUN g, double a, double b, 
                                             double c, double epsabs, double epsrel,
                                             Integer max_num_subint, double *result,
                                             double *abserr, Nag_QuadProgress *qp, 
                                             Nag_User *comm, NagError *fail);
  extern void d01sqv(NAG_D01_TS_FUN g, double a, double b, double c,
                     double epsabs, double epsrel, double alist[],
                     double blist[], double elist[], double rlist[],
                     Integer  limit, Integer iord[], double *result,
                     double *abserr, Integer *neval, Integer *last,Integer *ier,
                     Integer *funeval, char buf[], Nag_User *comm);
  extern void d01sqy(NAG_D01_TS_FUN g, double a, double b, double c,
                     double *result, double *abserr, Integer *krul,
                     Integer *neval, Integer *funeval, Nag_User *comm);
  extern NAG_DLL_EXPIMP void NAG_CALL d01ssc(NAG_D01SSC_FUN g, double a, 
                                             double omega, Nag_TrigTransform wt_func,
                                             Integer maxintervals,
                                             Integer maxsubint_per_int,
                                             double epsabs,
                                             double *result, double *abserr,
                                             Nag_QuadSubProgress *qpsub, Nag_User *comm, NagError *fail);
  extern void d01ssv(NAG_D01_TS_FUN g, double a, double epsabs,
                     double alist[], double blist[], double elist[],
                     double rlist[], double chebmo[], Integer maxp1,
                     double erlst[], double rslst[], Integer ierlst[],
                     Integer limlst, Integer limit, Integer iord[], 
                     Integer nnlog[], double *result, double *abserr,
                     double omega, Integer integr, Integer *lst, Integer *neval,
                     Integer *ier, Integer *funeval, char buf[], 
                     NagError *fail, Nag_User *comm);
  extern NAG_DLL_EXPIMP double NAG_CALL d01tac(Nag_GaussFormulae quadrule, NAG_D01TAC_FUN fun,
                                               double a, double b, Integer npts, Nag_User *comm, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL d01wcc(Integer ndim, NAG_D01WCC_FUN functn, double a[], 
                                             double b[], Integer *minpts, Integer maxpts,  double eps,
                                             double *finval, double *acc, Nag_User *comm, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL d01xbc(Integer numvar, NAG_D01XBC_FUN functn, 
                                             Nag_MCMethod method, Nag_Start cont, double a[], double b[],
                                             Integer *minpts, Integer maxpts, double releps, double *finval,
                                             double *relerr, double **wrkstr, 
                                             Nag_User *comm, NagError *fail);
  extern void d01xbz(Integer numvar, double a[], double b[],
                     Integer *minpts, Integer maxpts,
                     NAG_D01XBC_FUN functn,
                     double releps, double *relerr, double cntlim[],
                     double countr[], double lower[], double pointr[],
                     double bmnusa[], double width[], double x[],
                     Integer lenwrk, double wrkstr[], double *finval,
                     Integer *ierror, Nag_User *comm);
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGD01 */
